% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fotmob_matches.R
\name{fotmob_get_match_details}
\alias{fotmob_get_match_details}
\title{Get fotmob match details by match id}
\usage{
fotmob_get_match_details(match_ids)
}
\arguments{
\item{match_ids}{a vector of strings or numbers representing matches}
}
\value{
returns a dataframe of match shots
}
\description{
Returns match details from fotmob.com
}
\examples{
\donttest{
try({
library(dplyr)
library(tidyr)
results <- fotmob_get_matches_by_date(date = "20210926")
match_ids <- results \%>\%
  dplyr::select(primary_id, ccode, league_name = name, match_id) \%>\%
  dplyr::filter(league_name == "Premier League", ccode == "ENG") \%>\%
  dplyr::pull(match_id)
match_ids # 3609987 3609979
details <- fotmob_get_match_details(match_ids)
})
}
}
