% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_fb.R
\name{load_match_results}
\alias{load_match_results}
\title{Load match results}
\usage{
load_match_results(country, gender, season_end_year, tier)
}
\arguments{
\item{country}{the three character country code}

\item{gender}{gender of competition, either "M" or "F"}

\item{season_end_year}{the year(s) the season concludes}

\item{tier}{the tier of the league, ie '1st' for the EPL or '2nd' for the Championship and so on}
}
\value{
returns a dataframe with the results of the competition, season and gender
}
\description{
Loading version of \code{get_match_results}
Returns the game results for a given league season(s) from FBref
}
\examples{
\donttest{
try({
df <- load_match_results(
country = c("ITA"), gender = "M", season_end_year = 2021, tier = "1st"
)
# for results from English 1st div for men and women:
df <- load_match_results(
country = "ENG", gender = c("M", "F"), season_end_year = 2021, tier = "1st"
)
})
}
}
