% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendHist.R
\name{legendHist}
\alias{legendHist}
\title{Add histogram to existing plot}
\usage{
legendHist(
  x,
  colRamp = NULL,
  location = "bottomright",
  legTit = NULL,
  cex = 0.7,
  srt = 67,
  offS = NULL,
  border = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(numeric) main input/component of plot}

\item{colRamp}{(character or integer) set of colors, default is rainbow-like}

\item{location}{(character) for location of histogram inside existing plot (may be 'br','bl','tl','tr','bottomright', 'bottomleft','topleft','topright')}

\item{legTit}{(character, length=1) optional title for histogram-insert}

\item{cex}{(numeric) expansion factor (see also \code{\link[graphics]{par}})}

\item{srt}{(numeric) angle for histogram text labels (90 will give vertical label) (see also \code{\link[graphics]{par}})}

\item{offS}{(\code{NULL} or numeric, length=5) fine-tuning of where histogram-insert will be placed and how elements therein are ditributed 
(default c(xOff=0.2,yOff=0.25,leftOffS=0.05, upperBarEnd=1.05,txtOff=0.02),  
1st and 2nd determine proportio of insert relative to entire plotting region, 3rd defines space left on bottom for text, 
4th if bars hit ceiling of insert or proportion to leave, 5th for shifting text towards top when turned other than 90 degrees )}

\item{border}{(logical) decide of draw gray rectangle or not around legend}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
figure
}
\description{
Add histogram at pleace of legend using colors from 'colorRamp'.
}
\examples{
dat <- rnorm(90); plot(dat); legendHist(dat,col=1:5)
}
