% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAplotW.R
\name{MAplotW}
\alias{MAplotW}
\title{MA-plot (differential intensity versus average intensity)}
\usage{
MAplotW(
  Mvalue,
  Avalue = NULL,
  filtFin = NULL,
  ProjNa = NULL,
  FCthrs = NULL,
  subTxt = NULL,
  grayIncrem = TRUE,
  useComp = 1,
  compNa = NULL,
  batchFig = FALSE,
  cexMa = 1.8,
  cexLa = 0.7,
  limM = NULL,
  limA = NULL,
  cexPt = NULL,
  cexSub = NULL,
  useMar = c(6.2, 4, 4, 2),
  callFrom = "",
  silent = FALSE,
  debug = FALSE
)
}
\arguments{
\item{Mvalue}{(numeric or matrix) data to plot; M-values are typically calculated as difference of log2-abundance values and 'Avalue' the mean of log2-abundance values;
M-values and A-values may be given as 2 columsn of a matrix, in this case the argument \code{Avalue} should remain NULL}

\item{Avalue}{(numeric, list or data.frame) if \code{NULL} it is assumed that 2nd column of 'Mvalue' contains the A-values to be used}

\item{filtFin}{(matrix or logical) The data may get filtered before plotting: If \code{FALSE} no filtering will get applied; if matrix of \code{TRUE}/\code{FALSE} it will be used as optional custom filter, otherwise (if \code{Mvalue} if an \code{MArrayLM}-object eg from limma) a default filtering based on the \code{filtFin} element will be applied}

\item{ProjNa}{(character) custom title}

\item{FCthrs}{(numeric) Fold-Change threshold (display as line) give as Fold-change and NOT log2(FC)}

\item{subTxt}{(character) custom sub-title}

\item{grayIncrem}{(logical) if \code{TRUE}, display overlay of points as increased shades of gray}

\item{useComp}{(integer) choice of one of multiple comparisons present in \code{Mvalue} (if generated using \code{moderTestXgrp()})}

\item{compNa}{depreciated, please use \code{useComp} instead}

\item{batchFig}{(logical) if \code{TRUE} figure title and axes legends will be kept shorter for display on fewer splace}

\item{cexMa}{(numeric) expansion factor for font-size of title (see also \code{\link[graphics]{par}})}

\item{cexLa}{(numeric) expansion factor \code{cex} for labels (see also \code{\link[graphics]{par}})}

\item{limM}{(numeric, length=2) range of axis M-values}

\item{limA}{(numeric, length=2) range of axis A-values}

\item{cexPt}{(numeric)  expansion factor \code{cex} for points (see also \code{\link[graphics]{par}})}

\item{cexSub}{(numeric)  expansion factor \code{cex} for subtitle (see also \code{\link[graphics]{par}})}

\item{useMar}{(numeric,length=4) custom margings (see also \code{\link[graphics]{par}})}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}
}
\value{
MA-plot only
}
\description{
This type of plot is very common in high-throughput biology, see \href{https://en.wikipedia.org/wiki/MA_plot}{MA-plot}.
Basically one would like to compare numerous independent measures (ie gene transcript or protein abundance values) of 2 samples/data-sets,
it is usual to compare a change ('Minus'=M) versus absolute mean value ('Average'=A).
In high-throughput biology data are typically already transformed to log2 and thus, the 'M'-value represents a relative change.
Besides, output from statistical testing by \code{\link[wrMisc]{moderTest2grp}} can be directly read to produce MA plots for diagnostic reasons.
Please note, that plotting a very number of points in transparency (eg >10000) may take several seconds.
}
\examples{
library(wrMisc)
set.seed(2005); mat <- matrix(round(runif(600),1),ncol=6)
rownames(mat) <- c(rep(letters[1:25],each=3),letters[2:26])
MAplotW(mat[,2]-mat[,1], rowMeans(mat))
## assume 2 groups with 3 samples each
matMeans <- rowGrpMeans(mat, gr=gl(2,3,labels=LETTERS[3:4]))
MAplotW(matMeans[,2]-matMeans[,1], matMeans) 
## assume 2 groups with 3 samples each and run moderated t-test (from package 'limma')
tRes <- moderTest2grp(mat,gl(2,3))
MAplotW(tRes$Mval, tRes$Amean)                          
MAplotW(M=tRes$Mval, A=tRes$means, FCth=1.3) 
MAplotW(tRes)
MAplotW(tRes, limM=c(-2,2), FCth=1.3) 

}
\seealso{
(for PCA) \code{\link{plotPCAw}}
}
