% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumFrqPlot.R
\name{cumFrqPlot}
\alias{cumFrqPlot}
\title{Cumulative (or sorted) frequency plot (takes columns of 'dat' as separate series)}
\usage{
cumFrqPlot(
  dat,
  cumSum = FALSE,
  exclCol = NULL,
  colNames = NULL,
  displColNa = TRUE,
  tit = NULL,
  xLim = NULL,
  yLim = NULL,
  xLab = NULL,
  yLab = NULL,
  col = NULL,
  CVlimit = NULL,
  thisResol = NULL,
  supTxtAdj = 0,
  supTxtYOffs = 0,
  useLog = "",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) data to plot/inspect}

\item{cumSum}{(logical) for either plotting cumulates Sums (then \code{thisResol} for number of breaks) or (if \code{=FALSE}) simply sorted values -> max resolution}

\item{exclCol}{(integer) columlns to exclude}

\item{colNames}{(character) for alternative column/series names in display, as long as \code{displColNa=TRUE}}

\item{displColNa}{(logical) display column-names}

\item{tit}{(character) custom title}

\item{xLim}{(numeric) custom limit for x-axis (see also \code{\link[graphics]{par}})}

\item{yLim}{(numeric) custom limit for y-axis (see also \code{\link[graphics]{par}})}

\item{xLab}{(character) custom x-axis label}

\item{yLab}{(character) custom y-axis label}

\item{col}{(integer or character) custom colors}

\item{CVlimit}{(numeric) for the tag 'outlier column' (uses \code{\link[wrMisc]{exclExtrValues}})  identify & mark column with median row-CV > \code{CVlimit}}

\item{thisResol}{(integer) resolution \code{res} for binning large data-sets}

\item{supTxtAdj}{(numeric) parameter \code{adj} for supplemetal text}

\item{supTxtYOffs}{(numeric) supplemental offset for text on y axis}

\item{useLog}{(character) default="", otherwise for setting axis in log-scale "x", "y" or "xy"}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additonal messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function plots to the current garphical device
}
\description{
Display data as sorted or cumulative frequency plot. This type of plot represents an alternative to plotting data as histograms.
Histograms are very universal and which are very intuitive. However,fine-tuning the bandwith (ie width of the bars) may be very delicate, 
fine resultion details may often remain hidden. 
One of the advanges of directly displaying all data-points is that subtile differences may be revealed easier, compared to calssical histograms. 
Furthermore, the plot prensented her offeres more options to display multiple series of data simultaneaously. 
Thus, this type of plot may be useful to compare eg results of data normalization.
Of course, with very large data-sets (eg > 3000 values) this gain of 'details' will be less important (compared to histograms) and will penalize speed.
In such cases the argument \code{thisResol} will get useful as it allows to reduce the resultion and introduce binning.
Alternatively for very large data-sets one may looking into density-plots or vioplots (eg \code{\link{vioplotW}}).
The argument \code{CVlimit} allows optionally excluding extreme values. 
If numeric (& > 2 columns), its value will be used \code{\link[wrMisc]{exclExtrValues}} to identify series with column-median > 'CVlimit'.
Of course, exclusion of extreme values should be done with great care, important features of the data may get lost.
}
\examples{
set.seed(2017); dat0 <- matrix(rnorm(500), ncol=5, dimnames=list(NULL,1:5))
cumFrqPlot(dat0, tit="Sorted values")
cumFrqPlot(dat0, cumSum=TRUE, tit="Sum of sorted values")
}
\seealso{
\code{\link[graphics]{layout}}, \code{\link[wrMisc]{exclExtrValues}} for decision of potential outliers; \code{\link[graphics]{hist}}, \code{\link{vioplotW}}
}
