% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convMatr2df.R
\name{convMatr2df}
\alias{convMatr2df}
\title{Convert matrix (eg with redundant) row-names to data.frame}
\usage{
convMatr2df(mat, addIniNa = TRUE, duplTxtSep = "_", silent = FALSE,
  callFrom = NULL)
}
\arguments{
\item{mat}{matrix (or data.frame) to be converted}

\item{addIniNa}{(logical) add initial name}

\item{duplTxtSep}{(character) separator for enumerating replicated names}

\item{silent}{(logical) suppres messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
data.frame
}
\description{
\code{convMatr2df} provides flexible converting of matrix to data.frame. 
For example repeated/redundant rownames are not allowed in data.frame(), thus the corresponding column-names have to be renamed using a counter-suffix.
In case of non-redundant rownames, a new column 'addIniNa' will be introduced at beginning to document the initial (redundant) rownames, 
non-redundant rownames will be created.
Finally, this functions converts the corrected matrix to data.frame and checks/converts columns for transforming character to numeric. 
If the input is a data.frame containing factors, they will be converted to character before potential conversion.
Note: for simpler version (only text to numeric) see from this package \code{.convertMatrToNum} .
}
\examples{
dat1 <- matrix(1:10,ncol=2)
rownames(dat1) <- letters[c(1:3,2,5)]
## as.data.frame(dat1)  ...  would result in an error
convMatr2df(dat1)
convMatr2df(data.frame(a=as.character((1:3)/2),b=LETTERS[1:3],c=1:3))
tmp <- data.frame(a=as.character((1:3)/2),b=LETTERS[1:3],c=1:3,stringsAsFactors=FALSE)
convMatr2df(tmp)
tmp <- data.frame(a=as.character((1:3)/2),b=1:3,stringsAsFactors=FALSE)
convMatr2df(tmp) 
}
\seealso{
for simpler version (only text to numeric) see from this package \code{.convertMatrToNum}
}
