% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrNumericFromMatr.R
\name{extrNumericFromMatr}
\alias{extrNumericFromMatr}
\title{Extract numeric part of matrix or data.frame}
\usage{
extrNumericFromMatr(dat, trimToData = TRUE, silent = FALSE,
  callFrom = NULL)
}
\arguments{
\item{dat}{matrix (or data.frame) for extracting numeric parts}

\item{trimToData}{(logical) default to remove (crop) lines and cols contributing to NA, non-numeric data is transfomed to NA}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix of numeric data
}
\description{
\code{extrNumericFromMatr} extracts numeric part of matrix or data.frame, removing remaining non-numeric elements if \code{trimToData} is set to \code{TRUE}.
Note, that cropping entire lines where a (single) text element appeared may quickly reduce the overal content of the input data.
}
\examples{
mat <- matrix(c(letters[1:7],14:16,LETTERS[1:6]),nrow=4,dimnames=list(1:4,letters[1:4]))
mat; extrNumericFromMatr(mat)
mat <- matrix(c(letters[1:4],1,"e",12:19,LETTERS[1:6]),nr=5,dimnames=list(11:15,letters[1:4]))
mat; extrNumericFromMatr(mat)
}
