% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchLinesAtGivenSlope.R
\name{searchLinesAtGivenSlope}
\alias{searchLinesAtGivenSlope}
\title{Search points forming lines at given slope}
\usage{
searchLinesAtGivenSlope(dat, coeff = 1.5, filtExtr = c(0, 1),
  minMaxDistThr = NULL, lmCompare = TRUE, indexPoints = TRUE,
  displHist = FALSE, displScat = FALSE, bestCluByDistRat = TRUE,
  neighbDiLim = NULL, silent = FALSE, debugM = FALSE,
  callFrom = NULL)
}
\arguments{
\item{dat}{matrix or data.frame}

\item{coeff}{(numeric) slope to consider}

\item{filtExtr}{(integer) lower & upper quantile values, remove points with extreme deviation to offset=0, (if single value: everything up to or after will be used)}

\item{minMaxDistThr}{(logical) optional minumum and maximum distance threshold}

\item{lmCompare}{(logical) add'l fitting of linear regression to best results, return offset AND slope based on lm fit}

\item{indexPoints}{(logical) return results as list with element 'index' specifying retained points}

\item{displHist}{(logical) display histogram of residues}

\item{displScat}{(logical) display (simple) scatter plot}

\item{bestCluByDistRat}{(logical) initial selection of decent clusters based on ratio overallDist/averNeighbDist (or by CV & cor)}

\item{neighbDiLim}{(numeric) additional threshold for (trimmed mean) neighbour-distance}

\item{silent}{(logical) suppress messages}

\item{debugM}{(logical) for bug-tracking: more/enhanced messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix of line-characteristics  (or if indexPoints is \code{TRUE} then list (line-characteristics & index & lm-results)
}
\description{
\code{searchLinesAtGivenSlope} searchs among set of points (2-dim) those forming line(s) with user-defined slope ('coeff'),
 ie search optimal (slope-) offset parameter(s) for (regression) line(s) with given slope ('coef').
 Note: larger data-sets : segment residuals to 'coeff' & select most homogenous
}
\examples{
set.seed(2016); ra1 <- runif(300)
 dat1 <- cbind(x=round(c(1:100+ra1[1:100]/5,4*ra1[1:50]),1),
  y=round(c(1:100+ra1[101:200]/5,4*ra1[101:150]),1))
(li1 <- searchLinesAtGivenSlope(dat1,coeff=1))
}
