% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XYToDiffPpm.R
\name{XYToDiffPpm}
\alias{XYToDiffPpm}
\title{Express difference as ppm}
\usage{
XYToDiffPpm(x, y, nSign = NULL, silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{x}{(numeric) typically for measured variable}

\item{y}{(numeric) typically for theoretical/expected value (vector must be of same length as 'x')}

\item{nSign}{(integer) number of significant digits in output}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a numeric vector of (ratio-) ppm values
}
\description{
This function transforms offset (pariwise-difference) between 'x' & 'y' to ppm (as normalized difference ppm, parts per million, ie (x-y)/y ).
This type of expressiong differences is used eg in mass-spectrometry.
}
\examples{
set.seed(2017); aa <- runif(10,50,900)
cbind(x=aa,y=aa+1e-3,ppm=XYToDiffPpm(aa,aa+1e-3,nSign=4)) 
}
\seealso{
\code{\link{ratioToPpm}} for classical ppm
}
