% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendNR.R
\name{appendNR}
\alias{appendNR}
\title{Append vectors or lists, without duplcating common elements}
\usage{
appendNR(x, y, rmDuplicate = TRUE, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{x}{(vector or list) must have names to allow checking for duplicate names in y}

\item{y}{(vector or list) must have names to allow checking for duplicate names in x}

\item{rmDuplicate}{(logical) avoid duplicating liste-elements present in both x and y (based on names of list-elements)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
If both \code{x} and \code{y} are vectors, the output will be a vector, otherwise it will be a list
}
\description{
This function allows combining two vectors or lists without duplicating common content (definded by name of list-elements).
}
\details{
When setting the argument \code{rmDuplicate=FALSE} the function will behave like \code{append}.
}
\examples{
li1 <- list(a=1, b=2, c=3)
li2 <- list(A=11, B=12, c=3)
appendNR(li1, li2)
append(li1, li2) 
}
\seealso{
\code{\link[base]{append}}; \code{\link{lrbind}}
}
