% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkUnitPrefix.R
\name{checkUnitPrefix}
\alias{checkUnitPrefix}
\title{Check For Common Unit-Name in Text}
\usage{
checkUnitPrefix(
  x,
  pref = c("a", "f", "p", "n", "u", "m", "", "k", "M", "G", "T", "P"),
  unit = c("m", "s", "sec", "Mol", "mol", "g", "K", "cd", "A", "W", "Watt", "V", "Volt"),
  sep = c("", " ", ";", ",", "_", "."),
  sep2 = "",
  stringentSearch = FALSE,
  na.rm = FALSE,
  protSpecChar = TRUE,
  inclPat = FALSE,
  callFrom = NULL,
  silent = FALSE,
  debug = FALSE
)
}
\arguments{
\item{x}{(character) vector containing digit uunit-prefix and unit terms}

\item{pref}{(character) multiplicative unit-prefixes, assumes as increasing factors of 1000}

\item{unit}{(character) unit name, the numeric part may be sepatated by one space-character}

\item{sep}{(character) separator character(s) that may appear between integer numeric value and unit-prefix}

\item{sep2}{(character) separator character(s) after \code{unit}, set to \code{sep2=""} for ignoring characters following \code{unit}}

\item{stringentSearch}{(logical) if \code{TRUE} only matches with same separators (sep, sep2) pass, otherwise different elements may contain different separators}

\item{na.rm}{(logical) remove \code{NA} from input}

\item{protSpecChar}{(logical) protect special characters and use as they are instead of regex-meaning}

\item{inclPat}{(logical) return list including pattern of successful search}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}
}
\value{
This function returns a charcter vector (length=1) with the common unit name, if \code{inclPat=TRUE} it returns a list with $unit and $pattern
}
\description{
This function aims to find a unit abbreviation or name occurring in all elements of a character-vector \code{x}.
The unit name may be preceeded by different decimal prefixes (eg 'k','M'), as defined by argument \code{pref} and separators (\code{sep}). 
The unit name will be returned (or first of multiple).
}
\details{
Basically this function searches the pattern : digit + separator(\code{sep}) + prefix(\code{pref}) + \code{unit} + optional separator2(\code{sep2})
and returns the first unit-name/abbreviation found in all elements of \code{x}.

If \code{} if()
In case of invalid entries or no common unit-names \code{NULL} will be returned.

Please note the 'u' is used for 'micro' since handeling of special characters may not be portal between different operating systems.
}
\examples{
x1 <- c("10fg WW","xx 10fg 3pW"," 1pg 2.0W")
checkUnitPrefix(x1)
## different separators between digit and prefix:
x2 <- c("10fg WW","xx 8_fg 3pW"," 1 pg-2.0W")
checkUnitPrefix(x2, stringentSearch=TRUE)
checkUnitPrefix(x2, stringentSearch=FALSE)

x4 <- c("CT_mixture_QY_50_amol_CN_UPS1_CV_Standards_Research_Group",
  "CT_mixture_QY_5_fmol_CN_UPS1_CV_Standards_Research_Group")

}
\seealso{
\code{\link{convToNum}}; \code{\link{adjustUnitPrefix}}
}
