% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkVectLength.R
\name{checkVectLength}
\alias{checkVectLength}
\title{Check length of vector}
\usage{
checkVectLength(
  x,
  expeL = 1,
  stopOnProblem = FALSE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(numeric or charcter vector) input to check length}

\item{expeL}{(numeric) expected length}

\item{stopOnProblem}{(logical) continue on problems with message or stop (as error message)}

\item{silent}{(logical) suppress messages if \code{TRUE}}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
\code{NULL} (produces only optional message if length is OK or error-message if length is not OK)
}
\description{
\code{checkVectLength} checks argument 'x' for expected length 'expeL' and return either message or error when expectation not met. 
Used for parameter ('sanity') checking in other user front-end functions.
}
\examples{
aa <- 1:5; checkVectLength(aa,exp=3)
}
