% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrColsDeX.R
\name{extrColsDeX}
\alias{extrColsDeX}
\title{Flexible extraction of columns}
\usage{
extrColsDeX(x, extrCol, doExtractCols = FALSE, callFrom = NULL, silent = FALSE)
}
\arguments{
\item{x}{(matrix or data.frame) min input}

\item{extrCol}{(character or integer) columns to be extracted, may be column-names or column index}

\item{doExtractCols}{(logical) if default \code{FALSE} only the column indexes will be returned}

\item{callFrom}{(character) allows easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
integer-vector (if\code{doExtractCols=FALSE} return depending on input \code{matrix} or \code{data.frame})
}
\description{
This function provides flexible checking if a set of columns may be extracted from a matrix or data.frame 'x'.
}
\examples{
dFr <- data.frame(a=11:14,b=24:21,cc=LETTERS[1:4],dd=rep(c(TRUE,FALSE),2)) 
extrColsDeX(dFr,c("b","cc","notThere")) 
extrColsDeX(dFr,c("b","cc","notThere"),doExtractCols=TRUE) 
}
\seealso{
\code{\link[utils]{read.table}}, \code{\link{filterList}}
}
