% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankToContigTab.R
\name{rankToContigTab}
\alias{rankToContigTab}
\title{Contingenty tables for fit of ranking}
\usage{
rankToContigTab(dat, grp)
}
\arguments{
\item{dat}{(matrix or data.frame of integer values) ranking of multiple features (lines), equal ranks may occur}

\item{grp}{(integer) expected ranking}
}
\value{
array (1st dim is rows of dat, 2nd is unique(grp), 3rd dim is ok/bad)
}
\description{
Count the number of instances where the corresponding columns of 'dat' have a value matching the group number as specified by 'grp'.
Counting will be performed/repeated independently for each line of 'dat'.
Returns array  (1st dim is rows of dat, 2nd is unique(grp), 3rd dim is ok/bad), these results may be tested using eg \code{\link[stats]{fisher.test}}.
This function was made for prearing to test the ranking of multiple features (lines in 'mat') including replicates (levels of 'grp').
}
\examples{
# Let's create a matrix with ranks (equal ranks do occur)
ma0 <- matrix(rep(1:3,each=6),ncol=6,dimnames=list(
  c("li1","li2","ref"),letters[1:6]))
ma0[1,6] <- 1                       # create item not matching correctly
ma0[2,] <- c(3:1,2,1,3)             # create items not matching correctly
gr0 <- gl(3,2)                      # the expected ranking (as duplicates)
(count0 <- rankToContigTab(ma0,gr0))
cTab <- t(apply(count0,c(1,3),sum))
# Now we can compare the ranking of line1 to ref ...
fisher.test(cTab[,c(3,1)])          # test li1 against ref
fisher.test(cTab[,c(3,2)])          # test li2 against ref
}
\seealso{
\code{\link[stats]{lm}}
}
