% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXlsxBatch.R
\name{readXlsxBatch}
\alias{readXlsxBatch}
\title{Read batch of Excel xlsx-files}
\usage{
readXlsxBatch(
  fileNames = NULL,
  path = ".",
  fileExtension = "xlsx",
  excludeFiles = NULL,
  sheetInd = 1,
  checkFormat = TRUE,
  returnArray = TRUE,
  columns = c("Plate", "Well", "StainA"),
  simpleNames = 3,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{fileNames}{(character) provide either explicit list of file-names to be read or leave \code{NULL} for reading all files ending with 'xlsx' in path specified with argument \code{path}}

\item{path}{(character) there may be a different path for each file}

\item{fileExtension}{(character) extension of files (default='\code{xlsx}')}

\item{excludeFiles}{(character) names of files to exclude (only used when reading all files of given directory)}

\item{sheetInd}{(character or integer) specify which sheet to extract (as exact name of sheed or sheet-number, eg \code{sheetInd=2} will extract always the 2nd sheet (no matter the name); if given as sheet-name but nor present in file an empty list-elements wil be returned}

\item{checkFormat}{(logical) if \code{TRUE}: check header, remove empty columns, if rownames are increasing integeres it will searh for fisrt column with different entries to use as rownames}

\item{returnArray}{(logical) allows switching from array to list-output}

\item{columns}{(NULL or character) column-headers to be extracted (if specified, otherwise all columns will be extracted)}

\item{simpleNames}{(integer), if \code{NULL} all characters of fileNames will be maintained, otherwise allows truncating names (from beginning) to get to variable part (using .trimFromStart()), but keeping at least the number of charcters indicated by this argument}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
list
}
\description{
\code{readXlsxBatch} reads data out of multiple xlsx files, the sheet indicated by 'sheetInd' will be considered. 
All files must have the same organization of data, as this is typically the case when high-throughput measurements are automatically saved while experiments progress.
In particular, the first file read is used to structure the output.
By default all columns with text-content may be eliminated to keep the numeric part only, which may then get organized to a 3-dim numeric array 
 (where the additional files will be used as 2nd dimension and multiple columns per file shown as 3rd dimension). 
NOTE : (starting from version wrMisc-1.5.5) requires package \href{https://CRAN.R-project.org/package=readxl}{readxl} being installed ! 
(This allows much faster and memory efficient processing than previous use of package '\code{xlsx}')
}
\examples{
path1 <- system.file("extdata", package="wrMisc")
fiNa <- c("pl01_1.xlsx","pl01_2.xlsx","pl02_1.xlsx","pl02_2.xlsx")
datAll <- readXlsxBatch(fiNa, path1)
str(datAll)
## Now let's read all xlsx files of directory
datAll2 <- readXlsxBatch(path=path1, silent=TRUE)
identical(datAll, datAll2)
}
\seealso{
\code{\link[readxl]{read_excel}}; for simple reading of (older) xls-files under 32-bit R one may also see the package \href{https://CRAN.R-project.org/package=RODBC}{RODBC}
}
