% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_if_dot_args.R
\name{stop_if_dot_args}
\alias{stop_if_dot_args}
\title{Stop with message if dot_args is a non-trivial list.}
\usage{
stop_if_dot_args(dot_args, msg = "")
}
\arguments{
\item{dot_args}{substitute(list(...)) from another function.}

\item{msg}{character, optional message to prepend.}
}
\value{
NULL or stop()
}
\description{
Generate a stop with a good error message if the dots argument was a non-trivial list.
Useful in writing functions that force named arguments.
}
\examples{

f <- function(x, ..., inc = 1) {
   stop_if_dot_args(substitute(list(...)), "f")
   x + inc
}
f(7)
f(7, inc = 2)
tryCatch(
  f(7, 2),
  error = function(e) { print(e) }
)

}
