% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhsF0.R
\name{mhsF0}
\alias{mhsF0}
\alias{mhspitch}
\alias{f0_mhs}
\title{mhsF0}
\usage{
mhsF0(listOfFiles = NULL, optLogFilePath = NULL, beginTime = 0,
  centerTime = FALSE, endTime = 0, windowShift = 5, gender = "u",
  maxF = 600, minF = 50, minAmp = 50, minAC1 = 0.25, minRMS = 18,
  maxZCR = 3000, minProb = 0.52, plainSpectrum = FALSE, toFile = TRUE,
  explicitExt = NULL, outputDirectory = NULL,
  forceToLog = useWrasspLogger, verbose = TRUE)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds (default = 0: begin of file)}

\item{centerTime}{= <time>:  set single-frame analysis with the analysis 
window centred at <time> seconds; overrules beginTime, endTime and windowShift options}

\item{endTime}{= <time>: set end of analysis interval to <time> seconds (default = 0: end of file)}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms (default: 5.0)}

\item{gender}{= <code>  set gender-specific pitch ranges; <code> may be:
"f[emale]" (80.0 - 600.0 Hz)
"m[ale]" (50.0 - 375.0 Hz)
"u[nknown]" (default; 50.0 - 600.0 Hz)}

\item{maxF}{= <freq>: set maximum pitch value to <freq> Hz (default: 500.0)}

\item{minF}{= <freq>:  set minimum pitch value to <freq> Hz (default: 50.0  minimum: 25.0)}

\item{minAmp}{= <amp>:  minimum signal amplitude (default: 50)}

\item{minAC1}{= <freq>: minimum 1st correlation coefficient (default: 0.250)}

\item{minRMS}{= <num>:  minimum RMS amplitude in dB (default: 18.0)}

\item{maxZCR}{= <freq>: maximum zero crossing rate in Hz (default: 3000)}

\item{minProb}{= <num>: minimum quality value of F0 fit (default: 0.520)}

\item{plainSpectrum}{use plain rather than masked power spectrum}

\item{toFile}{write results to file (default extension is .pit)}

\item{explicitExt}{set if you wish to override the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return AsspDataObj of that file
}
\description{
mhsF0 function adapted from libassp
}
\details{
Pitch analysis of the speech signal in <listOfFile> using
Michel's/Modified Harmonic Sieve algorithm.
Analysis results will be written to a file with the
base name of the input file and extension '.pit'.
Default output is in SSFF binary format (track 'pitch').
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# calculate fundamental frequency contour
res <- mhsF0(path2wav, toFile=FALSE)

# plot fundamental frequency contour
plot(seq(0,numRecs.AsspDataObj(res) - 1) / rate.AsspDataObj(res) +
       attr(res, 'startTime'),
     res$pitch, 
     type='l', 
     xlab='time (s)', 
     ylab='F0 frequency (Hz)')

}
\seealso{
\code{\link{ksvF0}} for an tracking the fundamental frequency
}
\author{
Raphael Winkelmann

Lasse Bombien
}
