% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlmtest_methods.R
\name{wlmtest_methods}
\alias{wlmtest_methods}
\alias{summary.wlmtest}
\alias{print.wlmtest}
\alias{set_wlmobj.wlmtest}
\alias{set_drop.wlmtest}
\alias{set_signif.wlmtest}
\alias{set_ranks.wlmtest}
\alias{set_bandp.wlmtest}
\alias{get_wlmobj.wlmtest}
\alias{get_drop.wlmtest}
\alias{get_signif.wlmtest}
\alias{get_ranks.wlmtest}
\alias{get_bandp.wlmtest}
\title{Basic methods for the \code{wlmtest} class}
\usage{
\method{summary}{wlmtest}(object, ...)

\method{print}{wlmtest}(x, ...)

\method{set_wlmobj}{wlmtest}(obj, newval)

\method{set_drop}{wlmtest}(obj, newval)

\method{set_signif}{wlmtest}(obj, newval)

\method{set_ranks}{wlmtest}(obj, newval)

\method{set_bandp}{wlmtest}(obj, newval)

\method{get_wlmobj}{wlmtest}(obj)

\method{get_drop}{wlmtest}(obj)

\method{get_signif}{wlmtest}(obj)

\method{get_ranks}{wlmtest}(obj)

\method{get_bandp}{wlmtest}(obj)
}
\arguments{
\item{object, x, obj}{An object of class \code{wlmtest}}

\item{...}{Not currently used. Included for argument consistency
with existing generics.}

\item{newval}{A new value, for the \code{set_*} methods}
}
\value{
\code{summary.wlmtest} produces a summary of a \code{wlmtest} object.
A \code{print.wlmtest} method is also available. For \code{wlmtest} objects, 
\code{set_*} and \code{get_*} methods are available for all slots (see
the documentation for \code{wlmtest} for a list). The \code{set_*} methods 
just throw an error, to prevent breaking the consistency between the 
slots of a \code{wlmtest} object.
}
\description{
Set, get, summary, and print methods for the \code{wlmtest} class.
}
\examples{
times<-1:30
dat<-list(v1=matrix(rnorm(300),10,30),v2=matrix(rnorm(300),10,30),v3=matrix(rnorm(300),10,30),
          v4=matrix(rnorm(300),10,30),v5=matrix(rnorm(300),10,30))
dat<-lapply(FUN=function(x){cleandat(x,times,1)$cdat},X=dat)
resp<-1
pred<-2:3
norm<-"powall"
wlmobj<-wlm(dat,times,resp,pred,norm)
drop<-3
sigmethod<-"fft"
h<-wlmtest(wlmobj,drop,sigmethod,nrand=10)
get_times(get_wlmobj(h))
summary(h)
print(h)

}
\seealso{
\code{\link{wlmtest}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
