% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w.qqplot.R
\name{w.qqplot}
\alias{w.qqplot}
\title{plots for w p-values diagnosis}
\usage{
w.qqplot(data, w.order = c(1, 2), input.poolsize = 50,
  hf1 = "default.hf1", hf2 = "default.hf2", ...)
}
\arguments{
\item{data}{a data frame or matrix contains genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1).}

\item{w.order}{a numeric number taking values 1 or 2. If w.order = 1, main effect is calculated. If w.order = 2, pairwise interaction effect is calculated.}

\item{input.poolsize}{a numeric number; The maximum number of values used to calculate first or second order effects. The default is 200.}

\item{hf1}{a data frame or matrix, specifying the h and f parameters for order 1 calculation. Default values = HF1= array(c(0.5,0.667,1,2), dim=c(2,2)).}

\item{hf2}{a data frame or matrix, specifying the h and f parameters for order 2 calculation. Default values = HF2 = array(c(0.5,0.667,0.75,0.8,0.833,0.857,0.875,0.889,1:8), dim=c(8,2)).}

\item{...}{graphical parameters.}
}
\value{
Q-Q plot
}
\description{
To draw a Q-Q plot for W-test
}
\details{
The Q-Q plot for W-test is to use a set of randomly generated y as phenotype, to test its null distribution compared with chi-square distribution. To fit different type of data and adjust the distribution, h and f parameters are strongly recommended to calculate instead of the default hf1 and hf2 for first and second order, respectively.

The input.poolsize is suggested to set as 1000 for w.order = 1 and 200 for w.order = 2.
}
\examples{
data(mydata)
w.qqplot(mydata,w.order=2,cex=.5)
abline(0,1)
}

