% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{x3p_scale_unit}
\alias{x3p_scale_unit}
\title{Scale x3p object by given unit}
\usage{
x3p_scale_unit(x3p, scale_by)
}
\arguments{
\item{x3p}{object in x3p format, 3d topographic surface.}

\item{scale_by}{numeric value. Value the surface to be scaled by. While not enforced, values of \code{scale_by} make most sense as multiples of 10 (for a metric system).}
}
\value{
x3p with header information in microns
}
\description{
x3p objects can be presented in different units. ISO standard 5436_2 asks for specification of values in meters.
For topographic surfaces collected by microscopes values in microns are
more readable. This functions allows to convert between different units.
}
\examples{
logo <- read_x3p(system.file("csafe-logo.x3p", package="x3ptools"))
logo # measurements in meters
x3p_scale_unit(logo, scale_by=10^6) # measurements in microns
}
