% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_qqPlot}
\alias{xQTLvisual_qqPlot}
\title{plot quantile-quantile plot with pvalue}
\usage{
xQTLvisual_qqPlot(
  summaryDT,
  legend_p = FALSE,
  binCutLogP = 3,
  binNumber = 1000
)
}
\arguments{
\item{summaryDT}{A data.frame of one col required: pval.}

\item{legend_p}{TRUE or FALSE, or legend position, including: top, bottom, left and right.}

\item{binCutLogP}{SNPs whose logP great than this will be binned, other than not binned.}

\item{binNumber}{Number of bins.}
}
\value{
ggplot2 object
}
\description{
plot quantile-quantile plot with pvalue
}
\examples{
\donttest{
url1 <- "https://master.dl.sourceforge.net/project/exampledata/gwas/gwasSub.txt.gz"
snpInfo <- data.table::fread(url1, sep="\t")
xQTLvisual_qqPlot(snpInfo[,.(pValue)],binCutLogP=5, binNumber=10000)
}
}
