% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{retrieveLD}
\alias{retrieveLD}
\title{Retrieve SNP pairwise LD from locuscompare database}
\usage{
retrieveLD(chr, snp, population)
}
\arguments{
\item{chr}{(string) Chromosome name. e.g. '22'. Notice that the name should not contain 'chr'.}

\item{snp}{(string) SNP rsID.}

\item{population}{(string) One of the 5 popuations from 1000 Genomes: 'AFR', 'AMR', 'EAS', 'EUR', and 'SAS'.}
}
\value{
A data.frame object.
}
\description{
SNP pairwise lD are calculated based on 1000 Genomes Project Phase 3 version 5.
For storage-efficiency, the output will only include SNPs with r2 > 0.2 with the input SNP.
}
\examples{
ld <- retrieveLD('6', 'rs9349379', 'AFR')
}
