% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{theme_xaringan_get_value}
\alias{theme_xaringan_get_value}
\title{Get the Value of xaringanthemer Style Setting}
\usage{
theme_xaringan_get_value(setting, css_file = NULL)
}
\arguments{
\item{setting}{A xaringanthemer style setting}

\item{css_file}{Path to a \pkg{xaringanthemer} CSS file, from which the
theme variables and values will be inferred. In general, if you use the
\pkg{xaringathemer} defaults, you will not need to set this. This feature
lets you create a \pkg{ggplot2} theme for your \pkg{xaringan} slides, even
if you have only saved your theme CSS file and you aren't creating your
CSS theme with \pkg{xaringanthemer} in your slides' source file.}
}
\value{
The value of the xaringanthemer style parameter.
}
\description{
A helper function to retrieve the value of style settings as set by a
xaringanthemer style function, for use in plotting and other circumstances.
}
\section{Style Settings}{

Style settings used by xaringanthemer include:
\itemize{
\item \code{background_color}
\item \code{background_image}
\item \code{background_position}
\item \code{background_size}
\item \code{blockquote_left_border_color}
\item \code{code_font_family}
\item \code{code_font_family_fallback}
\item \code{code_font_google}
\item \code{code_font_is_google}
\item \code{code_font_size}
\item \code{code_font_url}
\item \code{code_highlight_color}
\item \code{code_inline_background_color}
\item \code{code_inline_color}
\item \code{code_inline_font_size}
\item \code{extra_css}
\item \code{extra_fonts}
\item \code{footnote_color}
\item \code{footnote_font_size}
\item \code{footnote_position_bottom}
\item \code{header_background_auto}
\item \code{header_background_color}
\item \code{header_background_content_padding_top}
\item \code{header_background_ignore_classes}
\item \code{header_background_padding}
\item \code{header_background_text_color}
\item \code{header_color}
\item \code{header_font_family}
\item \code{header_font_google}
\item \code{header_font_is_google}
\item \code{header_font_url}
\item \code{header_font_weight}
\item \code{header_h1_font_size}
\item \code{header_h2_font_size}
\item \code{header_h3_font_size}
\item \code{inverse_background_color}
\item \code{inverse_header_color}
\item \code{inverse_text_color}
\item \code{inverse_text_shadow}
\item \code{left_column_selected_color}
\item \code{left_column_subtle_color}
\item \code{link_color}
\item \code{padding}
\item \code{table_border_color}
\item \code{table_row_border_color}
\item \code{table_row_even_background_color}
\item \code{text_bold_color}
\item \code{text_color}
\item \code{text_font_base}
\item \code{text_font_family}
\item \code{text_font_family_fallback}
\item \code{text_font_google}
\item \code{text_font_is_google}
\item \code{text_font_size}
\item \code{text_font_url}
\item \code{text_font_weight}
\item \code{text_slide_number_color}
\item \code{text_slide_number_font_size}
\item \code{title_slide_background_color}
\item \code{title_slide_background_image}
\item \code{title_slide_background_position}
\item \code{title_slide_background_size}
\item \code{title_slide_text_color}
}
}

\examples{
# Create a xaringanthemer style in a temporary file for this example
xaringan_themer_css <- tempfile("xaringan-themer", fileext = ".css")

style_solarized_light(outfile = xaringan_themer_css)

theme_xaringan_get_value("text_color")
theme_xaringan_get_value("background_color")
theme_xaringan_get_value("header_color")
theme_xaringan_get_value("text_bold_color")

}
