% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpCrossover.R
\name{xegaGpCrossoverFactory}
\alias{xegaGpCrossoverFactory}
\title{Configure the crossover function of a grammar-based genetic algorithm.}
\usage{
xegaGpCrossoverFactory(method = "Cross2Gene")
}
\arguments{
\item{method}{String specifying the crossover function.}
}
\value{
Crossover function for genes.
}
\description{
\code{xegaGpCrossoverFactory()} implements the selection
             of one of the crossover functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error), if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item Crossover functions with two kids:
             \enumerate{
             \item "Cross2Gene"       returns \code{xegaGpAllCross2Gene()}.
             \item "AllCross2Gene"    returns \code{xegaGpAllCross2Gene()}.
             \item "FilterCross2Gene" returns \code{xegaGpFilterCross2Gene()}.
             }
             \item Crossover functions with one kid:
             \enumerate{
             \item "AllCrossGene" returns \code{xegaGpAllCrossGene()}.
             \item "FilterCrossGene" returns \code{xegaGpFilterCrossGene()}.
             }
             }
}
\examples{
XGeneTwo<-xegaGpCrossoverFactory("Cross2Gene")
XGeneOne<-xegaGpCrossoverFactory("FilterCrossGene")
gene1<-xegaGpInitGene(lFxegaGpGene)
gene2<-xegaGpInitGene(lFxegaGpGene)
XGeneTwo(gene1, gene2, lFxegaGpGene)
XGeneOne(gene1, gene2, lFxegaGpGene)
}
\seealso{
Other Configuration: 
\code{\link{xegaGpMutationFactory}()}
}
\concept{Configuration}
