% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{news2md}
\alias{news2md}
\title{Convert package news to the Markdown format}
\usage{
news2md(package, ..., output = "NEWS.md", category = TRUE)
}
\arguments{
\item{package, ...}{Arguments to be passed to \code{\link{news}()}.}

\item{output}{The output file path.}

\item{category}{Whether to keep the category names.}
}
\value{
If \code{output = NA}, returns the Markdown content as a character
  vector, otherwise the content is written to the output file.
}
\description{
Read the package news with \code{\link{news}()}, convert the result to
Markdown, and write to an output file (e.g., \file{NEWS.md}). Each package
version appears in a first-level header, each category (e.g., \samp{NEW
FEATURES} or \samp{BUG FIXES}) is in a second-level header, and the news
items are written into bullet lists.
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# news for the current version of R
xfun::news2md("R", Version == getRversion(), output = NA)
\dontshow{\}) # examplesIf}
}
