% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structure.R
\name{strict_list}
\alias{strict_list}
\alias{as_strict_list}
\alias{$.xfun_strict_list}
\alias{print.xfun_strict_list}
\title{Strict lists}
\usage{
strict_list(...)

as_strict_list(x)

\method{$}{xfun_strict_list}(x, name)

\method{print}{xfun_strict_list}(x, ...)
}
\arguments{
\item{...}{Objects (list elements), possibly named. Ignored in the
\code{print()} method.}

\item{x}{For \code{as_strict_list()}, the object to be coerced to a strict
list.

For \code{print()}, a strict list.}

\item{name}{The name (a character string) of the list element.}
}
\value{
Both \code{strict_list()} and \code{as_strict_list()} return a list
with the class \code{xfun_strict_list}. Whereas \code{as_strict_list()}
attempts to coerce its argument \code{x} to a list if necessary,
\code{strict_list()} just wraps its argument \code{...} in a list, i.e., it
will add another list level regardless if \code{...} already is of type
list.
}
\description{
A strict list is essentially a normal \code{\link[=list]{list()}} but it does not
allow partial matching with \code{$}.
}
\details{
To me, partial matching is often more annoying and surprising than
convenient. It can lead to bugs that are very hard to discover, and I have
been bitten by it many times. When I write \code{x$name}, I always mean
precisely \code{name}. You should use a modern code editor to autocomplete
the \code{name} if it is too long to type, instead of using partial names.
}
\examples{
library(xfun)
(z = strict_list(aaa = "I am aaa", b = 1:5))
z$a  # NULL!
z$aaa  # I am aaa
z$b
z$c = "create a new element"

z2 = unclass(z)  # a normal list
z2$a  # partial matching

z3 = as_strict_list(z2)  # a strict list again
z3$a  # NULL again!
}
