% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\docType{data}
\name{download_cache}
\alias{download_cache}
\title{Download a file from a URL and cache it on disk}
\format{
A list of methods:
\itemize{
\item \verb{$get(url, type, handler)} downloads a URL, caches it, and returns the file
content according to the value of \code{type} (possible values: \code{"text"} means
the text content; \code{"base64"} means the base64 encoded data; \code{"raw"} means
the raw binary content; \code{"auto"} is the default and means the type is
determined by the content type in the URL headers). Optionally a \code{handler}
function can be applied to the content.
\item \verb{$list()} gives the list of cache files.
\item \verb{$summary()} gives a summary of existing cache files.
\item \verb{$remove(url, type)} removes a single cache file.
\item \verb{$purge()} deletes all cache files.
}
}
\usage{
download_cache
}
\description{
This object provides methods to download files and cache them on disk.
}
\examples{\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# the first time it may take a few seconds
x1 = xfun::download_cache$get("https://www.r-project.org/")
head(x1)

# now you can get the cached content
x2 = xfun::download_cache$get("https://www.r-project.org/")
identical(x1, x2)  # TRUE

# a binary file
x3 = xfun::download_cache$get("https://yihui.org/images/logo.png", "raw")
length(x3)

# show a summary
xfun::download_cache$summary()
# remove a specific cache file
xfun::download_cache$remove("https://yihui.org/images/logo.png", "raw")
# remove all cache files
xfun::download_cache$purge()
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
