# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

read_connection_ <- function(con, chunk_size = 64 * 1024L) {
    .Call('xml2_read_connection_', PACKAGE = 'xml2', con, chunk_size)
}

doc_parse_file <- function(path, encoding = "", as_html = FALSE) {
    .Call('xml2_doc_parse_file', PACKAGE = 'xml2', path, encoding, as_html)
}

doc_parse_raw <- function(x, encoding, base_url = "", as_html = FALSE) {
    .Call('xml2_doc_parse_raw', PACKAGE = 'xml2', x, encoding, base_url, as_html)
}

doc_format <- function(x) {
    .Call('xml2_doc_format', PACKAGE = 'xml2', x)
}

doc_write <- function(x, path) {
    invisible(.Call('xml2_doc_write', PACKAGE = 'xml2', x, path))
}

doc_root <- function(x) {
    .Call('xml2_doc_root', PACKAGE = 'xml2', x)
}

doc_url <- function(x) {
    .Call('xml2_doc_url', PACKAGE = 'xml2', x)
}

unique_ns <- function(ns) {
    .Call('xml2_unique_ns', PACKAGE = 'xml2', ns)
}

doc_namespaces <- function(doc) {
    .Call('xml2_doc_namespaces', PACKAGE = 'xml2', doc)
}

node_name <- function(node, nsMap) {
    .Call('xml2_node_name', PACKAGE = 'xml2', node, nsMap)
}

node_text <- function(node, trim) {
    .Call('xml2_node_text', PACKAGE = 'xml2', node, trim)
}

node_attr <- function(node, name, missing, nsMap) {
    .Call('xml2_node_attr', PACKAGE = 'xml2', node, name, missing, nsMap)
}

node_attrs <- function(node, nsMap) {
    .Call('xml2_node_attrs', PACKAGE = 'xml2', node, nsMap)
}

node_format <- function(doc, node, format = TRUE, indent = 0L) {
    .Call('xml2_node_format', PACKAGE = 'xml2', doc, node, format, indent)
}

node_children <- function(node, onlyNode = TRUE) {
    .Call('xml2_node_children', PACKAGE = 'xml2', node, onlyNode)
}

node_length <- function(node, onlyNode = TRUE) {
    .Call('xml2_node_length', PACKAGE = 'xml2', node, onlyNode)
}

node_parents <- function(node) {
    .Call('xml2_node_parents', PACKAGE = 'xml2', node)
}

node_siblings <- function(node, onlyNode = TRUE) {
    .Call('xml2_node_siblings', PACKAGE = 'xml2', node, onlyNode)
}

node_parent <- function(n) {
    .Call('xml2_node_parent', PACKAGE = 'xml2', n)
}

node_write <- function(n, d, path) {
    invisible(.Call('xml2_node_write', PACKAGE = 'xml2', n, d, path))
}

node_path <- function(n) {
    .Call('xml2_node_path', PACKAGE = 'xml2', n)
}

nodes_duplicated <- function(nodes) {
    .Call('xml2_nodes_duplicated', PACKAGE = 'xml2', nodes)
}

node_type <- function(node) {
    .Call('xml2_node_type', PACKAGE = 'xml2', node)
}

#' Convert between relative and absolute urls.
#'
#' @param x A character vector of urls relative to that base
#' @param base A string giving a base url.
#' @return A character vector of urls
#' @seealso \code{\link{xml_url}} to retrieve the URL associated with a document
#' @export
#' @examples
#' url_absolute(c(".", "..", "/", "/x"), "http://hadley.nz/a/b/c/d")
#'
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz")
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz/")
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz/a/b")
#' url_relative("http://hadley.nz/a/c", "http://hadley.nz/a/b/")
url_absolute <- function(x, base) {
    .Call('xml2_url_absolute', PACKAGE = 'xml2', x, base)
}

#' @export
#' @rdname url_absolute
url_relative <- function(x, base) {
    .Call('xml2_url_relative', PACKAGE = 'xml2', x, base)
}

#' Parse a url into its component pieces.
#'
#' @param x A character vector of urls.
#' @return A dataframe with one row for each element of \code{x} and
#'   columns: scheme, server, port, user, path, query, fragment.
#' @export
#' @examples
#' url_parse("http://had.co.nz/")
#' url_parse("http://had.co.nz:1234/")
#' url_parse("http://had.co.nz:1234/?a=1&b=2")
#' url_parse("http://had.co.nz:1234/?a=1&b=2#def")
url_parse <- function(x) {
    .Call('xml2_url_parse', PACKAGE = 'xml2', x)
}

#' Escape and unescape urls.
#'
#' @param x A character vector of urls.
#' @param reserved A string containing additional characters to avoid escaping.
#' @export
#' @examples
#' url_escape("a b c")
#' url_escape("a b c", "")
#'
#' url_unescape("a%20b%2fc")
#' url_unescape("%C2%B5")
url_escape <- function(x, reserved = "") {
    .Call('xml2_url_escape', PACKAGE = 'xml2', x, reserved)
}

#' @export
#' @rdname url_escape
url_unescape <- function(x) {
    .Call('xml2_url_unescape', PACKAGE = 'xml2', x)
}

node_find_all <- function(node, doc, xpath, nsMap) {
    .Call('xml2_node_find_all', PACKAGE = 'xml2', node, doc, xpath, nsMap)
}

node_find_one <- function(node, doc, xpath, nsMap) {
    .Call('xml2_node_find_one', PACKAGE = 'xml2', node, doc, xpath, nsMap)
}

