% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwres.vs.cov.R
\name{cwres.vs.cov}
\alias{cwres.vs.cov}
\title{Conditional Weighted residuals (CWRES) plotted against covariates, for Xpose
4}
\usage{
cwres.vs.cov(
  object,
  ylb = "CWRES",
  smooth = TRUE,
  type = "p",
  main = "Default",
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{smooth}{A \code{NULL} value indicates that no superposed line should
be added to the graph. If \code{TRUE} then a smooth of the data will be
superimposed.}

\item{type}{1-character string giving the type of plot desired.  The
following values are possible, for details, see 'plot': '"p"' for points,
'"l"' for lines, '"o"' for over-plotted points and lines, '"b"', '"c"') for
(empty if '"c"') points joined by lines, '"s"' and '"S"' for stair steps and
'"h"' for histogram-like vertical lines.  Finally, '"n"' does not produce
any points or lines.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}} or
\code{link{xpose.plot.histogram}}.}
}
\value{
Returns a stack of xyplots and histograms of CWRES versus
covariates.
}
\description{
This creates a stack of plots of conditional weighted residuals (CWRES)
plotted against covariates, and is a specific function in Xpose 4. It is a
wrapper encapsulating arguments to the \code{xpose.plot.default} and
\code{xpose.plot.histogram} functions. Most of the options take their
default values from xpose.data object but may be overridden by supplying
them as arguments.
}
\details{
Each of the covariates in the Xpose data object, as specified in
\code{object@Prefs@Xvardef$Covariates}, is evaluated in turn, creating a
stack of plots.

Conditional weighted residuals (CWRES) require some extra steps to
calculate. See \code{\link{compute.cwres}} for details.

A wide array of extra options controlling xyplots and histograms are
available. See \code{\link{xpose.plot.default}} and
\code{\link{xpose.plot.histogram}} for details.
}
\examples{
## Here we load the example xpose database 
xpdb <- simpraz.xpdb

cwres.vs.cov(xpdb)

}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.plot.histogram}}, \code{\link[lattice]{xyplot}},
\code{\link[lattice]{histogram}}, \code{\link{xpose.prefs-class}},
\code{\link{compute.cwres}}, \code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres_wres_vs_x}},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
