% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind.plots.cwres.qq.R, R/ind.plots.wres.qq.R
\name{ind.plots.cwres.qq}
\alias{ind.plots.cwres.qq}
\alias{ind.plots.wres.qq}
\title{Quantile-quantile plots of weighted residuals for each individual in an
Xpose data object, for Xpose 4}
\usage{
ind.plots.cwres.qq(object, wres = "cwres", ...)

ind.plots.wres.qq(
  object,
  main = "Default",
  wres = "wres",
  layout = c(4, 4),
  inclZeroWRES = FALSE,
  subset = xsubset(object),
  scales = list(cex = 0.7, tck = 0.5),
  aspect = "fill",
  force.by.factor = TRUE,
  ids = F,
  as.table = TRUE,
  type = "o",
  pch = object@Prefs@Graph.prefs$pch,
  col = object@Prefs@Graph.prefs$col,
  cex = object@Prefs@Graph.prefs$cex,
  abllty = object@Prefs@Graph.prefs$abllty,
  abllwd = object@Prefs@Graph.prefs$abllwd,
  ablcol = object@Prefs@Graph.prefs$ablcol,
  prompt = FALSE,
  main.cex = 0.9,
  mirror = NULL,
  max.plots.per.page = 1,
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{wres}{Which weighted residual should we plot? Defaults to the WRES.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.qq}}.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{layout}{A list giving the layout of the graphs on the plot, in columns
and rows. The default is 4x4.}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES=0 is
included in the plot. The default is FALSE.}

\item{subset}{A string giving the subset expression to be applied to the
data before plotting. See \code{\link{xsubset}}.}

\item{scales}{See \code{\link{xpose.plot.qq}}.}

\item{aspect}{See \code{\link{xpose.plot.qq}}.}

\item{force.by.factor}{See \code{\link{xpose.plot.qq}}.}

\item{ids}{See \code{\link{xpose.plot.qq}}.}

\item{as.table}{See \code{\link{xpose.plot.qq}}.}

\item{type}{1-character string giving the type of plot desired.  The
following values are possible, for details, see 'plot': '"p"' for points,
'"l"' for lines, '"o"' for over-plotted points and lines, '"b"', '"c"') for
(empty if '"c"') points joined by lines, '"s"' and '"S"' for stair steps and
'"h"' for histogram-like vertical lines.  Finally, '"n"' does not produce
any points or lines.}

\item{pch}{The plotting character, or symbol, to use. Specified as an
integer. See R help on \code{\link{points}}. The default is an open circle.}

\item{col}{The color for lines and points. Specified as an integer or a text
string. A full list is obtained by the R command \code{colours()}. The
default is blue (col=4).}

\item{cex}{The amount by which plotting text and symbols should be scaled
relative to the default. 'NULL' and 'NA' are equivalent to '1.0'.}

\item{abllty}{Line type of the line of identity.}

\item{abllwd}{Line width of the line of identity.}

\item{ablcol}{Line colour of the line of identity.}

\item{prompt}{Specifies whether or not the user should be prompted to press
RETURN between plot pages. Default is FALSE.}

\item{main.cex}{The size of the title.}

\item{mirror}{Mirror plots are not yet implemented in this function and this
argument must contain a value of \code{NULL}}

\item{max.plots.per.page}{Maximum number of plots per page}
}
\value{
Returns a compound plot comprising QQ plots of weighted residuals
conditioned on individual.
}
\description{
This is a compound plot consisting of QQ plots of the distribution of
weighted residuals (any weighted residual produced by NONMEM) for every
individual in the dataset.  The function is a wrapper encapsulating
arguments to the \code{\link{xpose.plot.qq}} function.
}
\details{
Matrices of Q-Q plots of weighted residuals in each included individual are
displayed.

A wide array of extra options controlling Q-Q plots are available. See
\code{\link{xpose.plot.qq}} for details.
}
\section{Functions}{
\itemize{
\item \code{ind.plots.cwres.qq}: Q-Q plots of conditional 
weighted residuals for each individual
}}

\examples{

ind.plots.cwres.qq(simpraz.xpdb,subset="ID<18")

}
\seealso{
\code{\link{xpose.plot.qq}}, \code{\link{xpose.panel.qq}},
\code{\link{qqplot}}, \code{\link[lattice]{qqmath}},
\code{\link{xpose.prefs-class}}, \code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres_wres_vs_x}},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Justin Wilkins & Andrew Hooker
}
\concept{specific functions}
\keyword{methods}
