% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_xslt.R
\name{xml_xslt}
\alias{xml_xslt}
\alias{xslt}
\title{XSLT 1.0 Transformations}
\usage{
xml_xslt(doc, stylesheet)
}
\arguments{
\item{doc}{xml document as returned by \link[xml2:read_xml]{xml2::read_xml}}

\item{stylesheet}{another xml document containing the XSL stylesheet}
}
\description{
Transform an XML document by applying an XSL stylesheet.
}
\details{
This implementation supports XSLT 1.0 features plus most of the EXSLT set of
processor-portable extensions functions.

Unfortunately XSLT 2.0 or 3.0 features are only available in proprietary libraries
and currently unsupported. However XSLT 2.0 is not widely adopted anyway because
it is also unavailable in most browsers.
}
\examples{
doc <- read_xml(system.file("examples/cd_catalog.xml", package = "xslt"))
style <- read_xml(system.file("examples/cd_catalog.xsl", package = "xslt"))
html <- xml_xslt(doc, style)
cat(as.character(html))
}

