% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/colors.r
\name{xterm.pal}
\alias{display.xterm.pal}
\alias{xterm.pal}
\alias{xterm.pal.inv}
\title{Get predefined colour palettes}
\usage{
xterm.pal()

xterm.pal.inv()

display.xterm.pal()
}
\value{
A list of vectors with colour indices.
}
\description{
All except "GnRd" and "long" are basen on the color brewer palettes, see
\code{\link[RColorBrewer]{brewer.pal}} of the \code{RColorBrewer} package.
}
\examples{
display.xterm.pal()
pal <- xterm.pal()$Accent

freqs <- runif(6)
fruits <- factor(sample(6, size=30, replace=TRUE, freqs/sum(freqs)),
                 labels=c("apple", "grapes", "banana", "lemon",
                          "blueberry", "raspberry"))
for(i in 1:length(fruits))
    cat(style(fruits[i], "\\n", fg=pal[fruits[i]]))
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
display.xterm.pal, display.xterm.colors
}

