% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module1_3PLmodel.R
\name{irt.model.3pl}
\alias{irt.model.3pl}
\title{3-parameter-logistic Model}
\usage{
irt.model.3pl(people = NULL, items = NULL, responses = NULL)
}
\arguments{
\item{people}{a data frame of \code{theta} parameters}

\item{items}{a data frame of \code{a}, \code{b}, \code{c} parameters}

\item{responses}{a data frame of dichotomous responses}
}
\value{
a \code{irt.mode} object
}
\description{
\code{irt.model.3pl} creates a 3PL \code{irt.model} object
}
\details{
All arguments in \code{irt.model.3pl} are allowed to be \code{NULL}.
If not \code{NULL}, (a) the \code{people} argument is expected to be a data frame with a column named \code{theta}, 
the \code{items} argument is expected to be a data frame with three columns named \code{a}, \code{b}, and \code{c}, and  
the \code{responses} argument is expected to be a data frame with dimesions equal to the numbers of people (in rows) and items (in columns).\cr
}
\examples{
# create a 3pl model with manual inputs
people <- data.frame(theta=c(-1,0,1))
items <- data.frame(a=c(.5,1,1.5,1,1,1,1), b=c(0,0,0,-1,1,0,0), c=c(0,0,0,0,0,.1,.2))
responses <- data.frame(item1=c(0,0,1), item2=c(0,1,1), item3=c(0,1,1), 
item4=c(1,1,1), item5=c(0,0,1), item6=c(0,1,1), item7=c(1,1,1))
x <- irt.model.3pl(people, items, responses) 
x$probability(x)
x$information(x)
x$likelihood(x)
# create a 3pl model with generated data
x <- irt.model.3pl()$gen.data(10, 5)
x$probability(x)
x$information(x)
x$likelihood(x)
}

