% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorize_codelist.R
\name{factorize_codelist.data.frame}
\alias{factorize_codelist.data.frame}
\title{Coerce Data Frame Items with Codelists to Factor}
\usage{
\method{factorize_codelist}{data.frame}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Coerces items in data.frame with codelist attribute to factor.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
x \%>\% explicit_guide \%>\% as_yamlet
x \%>\% explicit_guide \%>\% factorize_codelist \%>\% as_yamlet
}
\seealso{
Other factorize_codelist: \code{\link{factorize_codelist.character}},
  \code{\link{factorize_codelist.default}},
  \code{\link{factorize_codelist.factor}},
  \code{\link{factorize_codelist}}
}
\concept{factorize_codelist}
\keyword{internal}
