% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rmd.R
\name{read_rmd}
\alias{read_rmd}
\alias{txt_body}
\title{Read R-markdown Documents}
\usage{
read_rmd(file, ..., skip_head = TRUE)

txt_body(...)
}
\arguments{
\item{file}{Character value indicating the path and the name to the Rmd file.}

\item{...}{Arguments passed by \code{read_rmd()} to \code{\link[=readLines]{readLines()}}.
In \code{txt_body()} they are character values passed to \code{c()}.}

\item{skip_head}{Logical value indicating whether the yaml head should be
skip or not.}
}
\value{
A character vector that can be use as argument for the parameter \code{body} in
the function \code{\link[=write_rmd]{write_rmd()}}.
}
\description{
The function \code{read_rmd()} reads Rmd files into character vectors pasting a
line break at the end of each line.
The function \code{txt_body()} will do the same to one or more character vectors.
}
\examples{
\dontrun{
Doc <- read_rmd(file.path(path.package("yamlme"), "taxlistjourney.Rmd"))
}

}
