% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rmd.R
\name{read_rmd}
\alias{read_rmd}
\alias{txt_body}
\title{Read R-markdown Documents}
\usage{
read_rmd(
  file,
  ...,
  append = "# document imported by 'read_rmd'",
  skip_head = TRUE
)

txt_body(...)
}
\arguments{
\item{file}{Character value indicating the path and the name to the Rmd file.}

\item{...}{Arguments passed by \code{read_rmd()} to \code{\link[=readLines]{readLines()}}.
In \code{txt_body()} they are character values passed to \code{c()}.}

\item{append}{Character value passed to function \code{\link[=read_rmd]{read_rmd()}}.}

\item{skip_head}{Logical value indicating whether the yaml head should be
skip or not (this argument is not used at the moment).}
}
\value{
An object of class \code{rmd_doc} by the function \code{read_rmd()}. The function
\code{txt_body()} retrieves a character vector suitable for the parameter \code{body}
in the function \code{\link[=write_rmd]{write_rmd()}}.
}
\description{
The function \code{read_rmd()} reads Rmd files into character vectors pasting a
line break at the end of each line.
The function \code{txt_body()} will do the same to one or more character vectors.
}
\examples{
\dontrun{
## Read pre-installed example
ex_document <- read_rmd(file.path(path.package("yamlme"),
    "taxlistjourney.Rmd"))

## Include this document as body
my_document <- write_rmd(
		title = "A journey in rOpenSci",
		author = "Miguel Alvarez",
		output = "html_document",
		body = ex_document)
}

}
