% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnn.parpred.R
\name{pnn.parpred}
\alias{pnn.parpred}
\title{Calculate predicted probabilities of PNN by using parallelism}
\usage{
pnn.parpred(net, x)
}
\arguments{
\item{net}{A PNN object generated by pnn.fit()}

\item{x}{A matrix of input predictors}
}
\value{
A matrix of predicted probabilities
}
\description{
The function \code{pnn.parpred} calculates a matrix of PNN predicted probabilities based on an input matrix
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
pnn.parpred(pnet, X[seq(5), ])
}
\seealso{
\code{\link{pnn.predict}}
}
