% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob-lift_curve.R
\name{lift_curve}
\alias{lift_curve}
\alias{lift_curve.data.frame}
\alias{autoplot.lift_df}
\title{Lift curve}
\usage{
lift_curve(data, ...)

\method{lift_curve}{data.frame}(data, truth, ..., na_rm = TRUE)

autoplot.lift_df(object, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected.
Otherwise, there should be as many columns as factor levels of \code{truth}.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names). For \code{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{object}{The \code{lift_df} data frame returned from \code{lift_curve()}.}
}
\value{
A tibble with class \code{lift_df} or \code{lift_grouped_df} having
columns:
\itemize{
\item \code{.n} - The index of the current sample.
\item \code{.n_events} - The index of the current \emph{unique} sample. Values with repeated
\code{estimate} values are given identical indices in this column.
\item \code{.percent_tested} - The cumulative percentage of values tested.
\item \code{.lift} - First calculate the cumulative percentage of true results relative to the
total number of true results. Then divide that by \code{.percent_tested}.
}
}
\description{
\code{lift_curve()} constructs the full lift curve and returns a
tibble. See \code{\link[=gain_curve]{gain_curve()}} for a closely related concept.
}
\details{
There is a \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}
method for quickly visualizing the curve. This works for
binary and multiclass output, and also works with grouped data (i.e. from
resamples). See the examples.
}
\section{Gain and Lift Curves}{


The motivation behind cumulative gain and lift charts is as a visual method to
determine the effectiveness of a model when compared to the results one
might expect without a model. As an example, without a model, if you were
to advertise to a random 10\% of your customer base, then you might expect
to capture 10\% of the of the total number of positive responses had you
advertised to your entire customer base. Given a model that predicts
which customers are more likely to respond, the hope is that you can more
accurately target 10\% of your customer base and capture
>10\% of the total number of positive responses.

The calculation to construct lift curves is as follows:
\enumerate{
\item \code{truth} and \code{estimate} are placed in descending order by the \code{estimate}
values (\code{estimate} here is a single column supplied in \code{...}).
\item The cumulative number of samples with true results relative to the
entire number of true results are found.
\item The cumulative \% found is divided by the cumulative \% tested
to construct the lift value. This ratio represents the factor of improvement
over an uninformed model. Values >1 represent a valuable model. This is the
y-axis of the lift chart.
}
}

\section{Multiclass}{


If a multiclass \code{truth} column is provided, a one-vs-all
approach will be taken to calculate multiple curves, one per level.
In this case, there will be an additional column, \code{.level},
identifying the "one" column in the one-vs-all calculation.
}

\section{Relevant level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the last level of the factor is considered the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\examples{
library(ggplot2)
library(dplyr)

# Two class - a tibble is returned
lift_curve(two_class_example, truth, Class1)

# Use autoplot to visualize
autoplot(lift_curve(two_class_example, truth, Class1))

# Multiclass one-vs-all approach
# One curve per level
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  lift_curve(obs, VF:L) \%>\%
  autoplot()

# Same as above, but will all of the resamples
hpc_cv \%>\%
  group_by(Resample) \%>\%
  lift_curve(obs, VF:L) \%>\%
  autoplot()

}
\seealso{
Other curve metrics: \code{\link{gain_curve}},
  \code{\link{pr_curve}}, \code{\link{roc_curve}}
}
\author{
Max Kuhn
}
\concept{curve metrics}
