# Generated by extendr: Do not edit by hand
#
# This file was created with the following call:
#   .Call("wrap__make_ymd_wrappers", use_symbols = TRUE, package_name = "ymd")

#' @docType package
#' @usage NULL
#' @useDynLib ymd, .registration = TRUE
NULL

#' Convert 'YMD' format integer or string to Date
#'
#' Transform integer or strings vectors in 'YMD' format to Date objects.
#' It intends to only support limited formats (no separator or one of
#' '.', ' ', '-' and '/' separators). See the possible formats in examples.
#'
#' @param x An integer or string vector in 'YMD' format. Double
#'   values without the decimal part are allowed.
#' @return A Date object. When the parse fails for certain input,
#'   the value returned would be `NA`, silently.
#'
#' @examples
#' ymd(c(210326, 19981225))
#' ymd(c("2020/1/8", "20 1 7", "1998.7.1", "1990-02-03"))
#'
#' @export
ymd <- function(x) .Call(wrap__ymd, x)

period_begin <- function(x, unit) .Call(wrap__period_begin, x, unit)

period_end <- function(x, unit) .Call(wrap__period_end, x, unit)

#' Calculate the date before / after months
#' @param ref_date a Date vector
#' @param months the number of months that's added to `ref_date`
#' @note The function name is the same as the Excel function `EDATE()` and
#'   does the same. It returns the date that is the indicated number of months
#'   before or after the ref date.
#' @examples
#' edate(as.Date("2020-01-31"), 1)
#' ## supports 'YMD' formatted integer or string
#' edate(200131, 1)
#' edate(200229, -12)
#'
#' @export
edate <- function(ref_date, months) .Call(wrap__edate, ref_date, months)

