% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_pagedown.R
\name{yml_pagedown_opts}
\alias{yml_pagedown_opts}
\title{Top-level YAML options for pagedown}
\usage{
yml_pagedown_opts(.yml, toc = yml_blank(), toc_title = yml_blank(),
  lot = yml_blank(), lot_title = yml_blank(),
  chapter_name = yml_blank(), links_to_footnotes = yml_blank(),
  paged_footnotes = yml_blank())
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \code{yml_*()} function}

\item{toc}{Logical. Use a table of contents?}

\item{toc_title}{The title for the table of contents. Note that the actual
YAML field is \code{toc-title}}

\item{lot}{Logical. Use a list of figures?}

\item{lot_title}{The title for the list of figures. Note that the actual YAML
field is \code{lot-title}}

\item{chapter_name}{The chapter title prefix}

\item{links_to_footnotes}{Logical. Transform all the URLs to footnotes? Note
that the actual YAML field is \code{links-to-footnotes}}

\item{paged_footnotes}{Logical. Render notes as footnotes? Note that the
actual YAML field is \code{paged-footnotes}}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}
}
\value{
a \code{yml} object
}
\description{
pagedown offers several output functions for paginated output, resumes,
business cards, theses, and morem as described in the \href{https://pagedown.rbind.io/}{pagedown vignette}. pagedown also accepts a few custom
top-level YAML. See \code{\link[=pagedown_business_card_template]{pagedown_business_card_template()}} for more on setting
up the YAML for a business card.
}
\examples{

yml() \%>\%
  yml_pagedown_opts(
    toc = TRUE,
    toc_title = "TOC",
    chapter_name = c("CHAPTER\\\\ ", "."),
    links_to_footnotes = TRUE
  )

}
\seealso{
Other yml: \code{\link{asis_yaml_output}},
  \code{\link{bib2yml}}, \code{\link{draw_yml_tree}},
  \code{\link{has_field}}, \code{\link{read_json}},
  \code{\link{use_yml_defaults}},
  \code{\link{use_yml_file}}, \code{\link{use_yml}},
  \code{\link{yml_author}},
  \code{\link{yml_blogdown_opts}},
  \code{\link{yml_bookdown_opts}},
  \code{\link{yml_citations}}, \code{\link{yml_clean}},
  \code{\link{yml_distill_opts}},
  \code{\link{yml_latex_opts}}, \code{\link{yml_output}},
  \code{\link{yml_params}}, \code{\link{yml_pkgdown}},
  \code{\link{yml_reference}}, \code{\link{yml_replace}},
  \code{\link{yml_resource_files}},
  \code{\link{yml_rsconnect_email}},
  \code{\link{yml_rticles_opts}},
  \code{\link{yml_runtime}}, \code{\link{yml_site_opts}},
  \code{\link{yml_toc}}, \code{\link{yml_vignette}}

Other pagedown: \code{\link{pagedown_business_card_template}}
}
\concept{pagedown}
\concept{yml}
