% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radio.R
\name{radiobarInput}
\alias{radiobarInput}
\alias{updateRadiobarInput}
\title{Radiobar inputs}
\usage{
radiobarInput(id, choices, values = choices, selected = values[[1]], ...)

updateRadiobarInput(
  id,
  choices = NULL,
  values = choices,
  selected = NULL,
  enable = NULL,
  disable = NULL,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character vector or list of tag elements specifying the
labels of the input's choices.}

\item{values}{A vector specifying the values of the input's choices,
defaults to \code{choices}.}

\item{selected}{One of \code{values} specifying the input's default selected
choice, defaults to \code{values[[1]]}.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
A stylized group of radio inputs. A radiobar input is similar to a button
group, but with a checked or highlighted stated. Additionally, only one value
at most may be selected at any given time.
}
\examples{

### Radiobars

radiobarInput(
  id = "radiobar1",
  choices = c(
    "fusce sagittis",
    "libero non molestie",
    "magna orci",
    "ultrices dolor"
  ),
  selected = "ultrices dolor"
) \%>\%
  background("grey")

}
\seealso{
Other inputs: 
\code{\link{buttonGroupInput}()},
\code{\link{buttonInput}()},
\code{\link{checkbarInput}()},
\code{\link{checkboxInput}()},
\code{\link{chipInput}()},
\code{\link{fileInput}()},
\code{\link{formInput}()},
\code{\link{listGroupInput}()},
\code{\link{menuInput}()},
\code{\link{navInput}()},
\code{\link{radioInput}()},
\code{\link{rangeInput}()},
\code{\link{selectInput}()},
\code{\link{textInput}()}
}
\concept{inputs}
