% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batsmanCumulativeAverageRuns.R
\name{batsmanCumulativeAverageRuns}
\alias{batsmanCumulativeAverageRuns}
\title{Batsman's cumulative average runs}
\usage{
batsmanCumulativeAverageRuns(df,name= "A Leg Glance",dateRange,staticIntv=1)
}
\arguments{
\item{df}{Data frame}

\item{name}{Name of batsman}

\item{dateRange}{Date interval to consider}

\item{staticIntv}{Static or interactive -staticIntv =1 (static plot) &  staticIntv =2 (interactive  plot)}
}
\value{
None
}
\description{
This function computes and plots the cumulative average runs of a batsman
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get the data frame for Kohli
kohli <- getBatsmanDetails(team="India",name="Kohli",dir=pathToFile)
batsmanCumulativeAverageRuns(kohli,"Kohli",dateRange)
}
}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{batsmanCumulativeStrikeRate}}
\code{\link{bowlerCumulativeAvgEconRate}}
\code{\link{bowlerCumulativeAvgWickets}}
\code{\link{batsmanRunsVsStrikeRate}}
\code{\link{batsmanRunsPredict}}
}
\author{
Tinniam V Ganesh
}
