% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json-opts.R
\name{opts_read_json}
\alias{opts_read_json}
\title{Create named list of options for parsing R from JSON}
\usage{
opts_read_json(
  promote_num_to_string = FALSE,
  df_missing_list_elem = NULL,
  obj_of_arrs_to_df = TRUE,
  arr_of_objs_to_df = TRUE,
  str_specials = c("string", "special"),
  num_specials = c("special", "string"),
  int64 = c("string", "double", "bit64"),
  length1_array_asis = FALSE,
  yyjson_read_flag = 0L
)
}
\arguments{
\item{promote_num_to_string}{Should numeric values be promoted to strings
when they occur within an array with other string values?  Default: FALSE
means to keep numerics as numeric value and promote the \emph{container} to
be a \code{list} rather than an atomic vector when types are mixed.  If \code{TRUE}
then array of mixed string/numeric types will be promoted to all
string values and returned as an atomic character vector.  Set this to \code{TRUE}
if you want to emulate the behaviour of \code{jsonlite::fromJSON()}}

\item{df_missing_list_elem}{R value to use when elements are missing in list
columns in data.frames. Default: NULL}

\item{obj_of_arrs_to_df}{logical. Should a named list of equal-length
vectors be promoted to a data.frame?  Default: TRUE.  If FALSE, then
result will be left as a list.}

\item{arr_of_objs_to_df}{logical. Should an array or objects be promoted to a
a data.frame? Default: TRUE. If FALSE, then results will be read as a
list-of-lists.}

\item{str_specials}{Should \code{'NA'} in a JSON string be converted to the \code{'special'}
\code{NA} value in R, or left as a \code{'string'}.  Default: 'string'}

\item{num_specials}{Should JSON strings 'NA'/'Inf'/'NaN' in a numeric context
be converted to the \code{'special'} R numeric values
\code{NA, Inf, NaN}, or left as a \code{'string'}. Default: 'special'}

\item{int64}{how to encode large integers which do not fit into R's integer
type.  'string' imports them as a character vector. 'double' will
convert the integer to a double precision numeric value. 'bit64' will
use the 'integer64' type from the 'bit64' package.  Note that the
'integer64' type is a \emph{signed} integer type, and a warning will
be issued if JSON contains an \emph{unsigned} integer which cannot
be stored in this type.}

\item{length1_array_asis}{logical. Should JSON arrays with length = 1 be
marked with class \code{AsIs}.  Default: FALSE}

\item{yyjson_read_flag}{integer vector of internal \code{yyjson}
options.  See \code{yyjson_read_flag} in this package, and read
the yyjson API documentation for more information.  This is considered
an advanced option.}
}
\value{
Named list of options for reading JSON
}
\description{
Create named list of options for parsing R from JSON
}
\examples{
opts_read_json()
}
\seealso{
\code{\link[=yyjson_read_flag]{yyjson_read_flag()}}
}
