% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hall-Yarborough.R
\name{z.HallYarborough}
\alias{z.HallYarborough}
\title{Hall-Yarborough correlation}
\usage{
z.HallYarborough(pres.pr, temp.pr, tolerance = 1e-13, verbose = FALSE)
}
\arguments{
\item{pres.pr}{pseudo-reduced pressure}

\item{temp.pr}{pseudo-reduced temperature}

\item{tolerance}{controls the iteration accuracy}

\item{verbose}{print internal}
}
\description{
Hall-Yarborough correlation
}
\examples{
# get z value from a Tpr at Ppr
z.HallYarborough(pres.pr = 1.5, temp.pr = 2.0)
z.HallYarborough(pres.pr = 1.5, temp.pr = 1.1)

# for two given Tpr and Ppr vectors, find the calculated z points
ppr <- c(0.5, 1.5, 2.5, 3.5, 4.5, 5.5, 6.5)
tpr <- c(1.3, 1.5, 1.7, 2)
hy <- z.HallYarborough(pres.pr = ppr, temp.pr = tpr)
print(hy)
}
