% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZenodoRequest.R
\docType{class}
\name{ZenodoRequest}
\alias{ZenodoRequest}
\title{ZenodoRequest}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a generic Zenodo request
}
\description{
ZenodoRequest

ZenodoRequest
}
\note{
Abstract class used internally by \pkg{zen4R}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Request}
\keyword{Zenodo}
\section{Super class}{
\code{\link[zen4R:zen4RLogger]{zen4R::zen4RLogger}} -> \code{ZenodoRequest}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ZenodoRequest-new}{\code{ZenodoRequest$new()}}
\item \href{#method-ZenodoRequest-execute}{\code{ZenodoRequest$execute()}}
\item \href{#method-ZenodoRequest-getRequest}{\code{ZenodoRequest$getRequest()}}
\item \href{#method-ZenodoRequest-getRequestHeaders}{\code{ZenodoRequest$getRequestHeaders()}}
\item \href{#method-ZenodoRequest-getStatus}{\code{ZenodoRequest$getStatus()}}
\item \href{#method-ZenodoRequest-getResponse}{\code{ZenodoRequest$getResponse()}}
\item \href{#method-ZenodoRequest-getException}{\code{ZenodoRequest$getException()}}
\item \href{#method-ZenodoRequest-getResult}{\code{ZenodoRequest$getResult()}}
\item \href{#method-ZenodoRequest-setResult}{\code{ZenodoRequest$setResult()}}
\item \href{#method-ZenodoRequest-clone}{\code{ZenodoRequest$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="ERROR"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-ERROR'><code>zen4R::zen4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="INFO"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-INFO'><code>zen4R::zen4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="WARN"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-WARN'><code>zen4R::zen4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="getClass"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-getClass'><code>zen4R::zen4RLogger$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="getClassName"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-getClassName'><code>zen4R::zen4RLogger$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="logger"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-logger'><code>zen4R::zen4RLogger$logger()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-new"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \code{ZenodoRequest}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$new(
  url,
  type,
  request,
  data = NULL,
  file = NULL,
  progress = FALSE,
  accept = "application/vnd.inveniordm.v1+json",
  token,
  logger = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{request URL}

\item{\code{type}}{Type of request: 'GET', 'POST', 'PUT', 'DELETE'}

\item{\code{request}}{the method request}

\item{\code{data}}{payload (optional)}

\item{\code{file}}{to be uploaded (optional)}

\item{\code{progress}}{whether a progress status has to be displayed for download/upload}

\item{\code{accept}}{accept header. Default is "application/vnd.inveniordm.v1+json"}

\item{\code{token}}{user token}

\item{\code{logger}}{the logger type}

\item{\code{...}}{any other arg}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-execute"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-execute}{}}}
\subsection{Method \code{execute()}}{
Executes the request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$execute()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-getRequest"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-getRequest}{}}}
\subsection{Method \code{getRequest()}}{
Get request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$getRequest()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-getRequestHeaders"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-getRequestHeaders}{}}}
\subsection{Method \code{getRequestHeaders()}}{
Get request headers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$getRequestHeaders()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-getStatus"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-getStatus}{}}}
\subsection{Method \code{getStatus()}}{
Get request status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$getStatus()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-getResponse"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-getResponse}{}}}
\subsection{Method \code{getResponse()}}{
Get request response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$getResponse()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-getException"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-getException}{}}}
\subsection{Method \code{getException()}}{
Get request exception
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$getException()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-getResult"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-getResult}{}}}
\subsection{Method \code{getResult()}}{
Get request result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$getResult()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-setResult"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-setResult}{}}}
\subsection{Method \code{setResult()}}{
Set request result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$setResult(result)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{result}}{result to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRequest-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRequest-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRequest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
