% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_deposit.R
\name{download_deposit}
\alias{download_deposit}
\title{Download files from a Zenodo deposit}
\usage{
download_deposit(list_deposit, file_name = NULL, dest, quiet = FALSE)
}
\arguments{
\item{list_deposit}{data.frame or tibble. Obtained with \link{list_deposit}.}

\item{file_name}{character. If \code{NULL}, all files from the file list. If a file name is specified, only this file will be downloaded.}

\item{dest}{character. Destination folder.}

\item{quiet}{logical. Show download info and progress bar.}
}
\value{
No return value. The function downloads files to the specified destination.
}
\description{
Download files from a Zenodo deposit
}
\examples{
\dontshow{if (curl::has_internet() & RCurl::url.exists("https://zenodo.org/records/10959197", timeout.ms = 5000)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
res <- list_deposit(deposit_id = 10959197)
temp_dir <- tempdir()
download_deposit(list_deposit = res, dest = temp_dir, quiet = FALSE)
file.exists(file.path(temp_dir, "iris.rds"))
file.exists(file.path(temp_dir, "mtcars.rds"))
\dontshow{\}) # examplesIf}
}
