% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenpath.R
\name{extract_pairs}
\alias{extract_pairs}
\title{Extract Pairs from a Path of Indices}
\usage{
extract_pairs(x, n)
}
\arguments{
\item{x}{the path, a \code{\link{vector}} or
\code{\link{list}} of indices of the variables to be plotted.}

\item{n}{A \code{\link{vector}} of length two giving the number 
of pairs to extract from the path \code{x} (if \code{NULL}, all pairs are
returned (nothing extracted); if of length one, it is replicated in the pair).
The first number corresponds to the beginning of the path,
the second to the end; at least one of the two numbers should be >= 1.}
}
\value{
returns an object of the same type as the input
\code{x} but (possibly) shortened. It extracts the first/last so-many
pairs of \code{x}.
}
\description{
Extracts pairs from a path of indices, representing the path
by the pairs (connected by common variable) and return a shortened path.
}
\examples{
## Begin with a path
(zp <- zenpath(c(3, 5), method = "eulerian.cross")) # integer(2) argument

## Extract the first two pairs and last four of indices
extract_pairs(zp, n = c(2, 4))

## Extract the first and last three pairs of indices
extract_pairs(zp, n = 3) # the 3 is repeated automatically


}
\seealso{
\code{\link{zenplot}()} which provides the zenplot.

Other tools related to constructing zenpaths: 
\code{\link{connect_pairs}()},
\code{\link{graph_pairs}()},
\code{\link{groupData}()},
\code{\link{indexData}()},
\code{\link{zenpath}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{tools related to constructing zenpaths}
