% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dloon.R
\name{points_2d_loon}
\alias{points_2d_loon}
\title{Point plot in 2d using the interactive loon package}
\usage{
points_2d_loon(
  zargs,
  showLabels = FALSE,
  showScales = FALSE,
  showGuides = FALSE,
  linkingGroup = NULL,
  linkingKey = NULL,
  glyph = "ocircle",
  itemLabel = NULL,
  showItemLabels = TRUE,
  parent = NULL,
  group... = NULL,
  ...
)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines are displayed}

\item{linkingGroup}{The initial linking group}

\item{linkingKey}{List of IDs to link on}

\item{glyph}{String determining the glyph type to be displayed for points, default is an open circle: "ocircle"}

\item{itemLabel}{A vector of strings to serve as the item label}

\item{showItemLabels}{Logical determing whether item labels display on mouse hover}

\item{parent}{The tk parent for this loon plot widget}

\item{group...}{A list of arguments passed to group_2d_loon (or NULL)}

\item{...}{Additional arguments passed to loon::l_plot()}
}
\value{
A loon plot
}
\description{
Point plot in 2d using the interactive loon package
}
\seealso{
Other default 2d plot functions using the interactive loon package: 
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_loon}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_loon}()},
\code{\link{rect_2d_loon}()}

Other default 2d plot functions: 
\code{\link{arrow_2d_graphics}()},
\code{\link{arrow_2d_grid}()},
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_graphics}()},
\code{\link{axes_2d_grid}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_graphics}()},
\code{\link{density_2d_grid}()},
\code{\link{density_2d_loon}()},
\code{\link{extract_2d}()},
\code{\link{group_2d_graphics}()},
\code{\link{group_2d_grid}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_graphics}()},
\code{\link{label_2d_grid}()},
\code{\link{label_2d_loon}()},
\code{\link{points_2d_graphics}()},
\code{\link{points_2d_grid}()},
\code{\link{qq_2d_graphics}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_graphics}()},
\code{\link{rect_2d_grid}()},
\code{\link{rect_2d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using the interactive loon package}
