% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Plot.zeta.ddecay}
\alias{Plot.zeta.ddecay}
\title{Zeta distance-decay plotting}
\usage{
Plot.zeta.ddecay(zeta.ddecay)
}
\arguments{
\item{zeta.ddecay}{A list produced by the function \code{Zeta.ddecay}.}
}
\value{
A plot of the zeta distance-decay with distance on the x-axis and the value of zeta on the y-axis.
}
\description{
Plots the output of the function \code{Zeta.ddecay}.
}
\examples{
utils::data(bird.spec.coarse)
xy.bird <- bird.spec.coarse[,1:2]
data.spec.bird <- bird.spec.coarse[,3:193]

dev.new()
zeta.ddecay.bird <- Zeta.ddecay(xy.bird, data.spec.bird, sam = 100, order = 3,
    confint.level = 0.95,plot=FALSE)
Plot.zeta.ddecay(zeta.ddecay.bird)

##########

utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

zeta.ddecay.marion <- Zeta.ddecay(xy.marion, data.spec.marion, sam = 100, order = 3,
    confint.level = 0.95, trsf = "log", normalize = TRUE,plot=FALSE)
dev.new()
Plot.zeta.ddecay(zeta.ddecay.marion)

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}, \code{\link{Zeta.ddecay}},

\code{\link{Zeta.ddecays}}
}

