% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.decline.ex}
\alias{Zeta.decline.ex}
\title{Expectation of zeta diversity decline}
\usage{
Zeta.decline.ex(
  data.spec,
  orders = 1:10,
  sd.correct = TRUE,
  confint.level = 0.95,
  sd.plot = TRUE,
  rescale = FALSE,
  empty.row = "empty",
  plot = TRUE
)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{orders}{Range of number of assemblages or sites for which zeta diversity is computed.}

\item{sd.correct}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be computed with an unbiased estimator (using the number of site combinations - 1 as the denominator) or not (using the number of site combinations as the denominator).}

\item{confint.level}{Percentage for the confidence intervals of the coefficients from the regressions.}

\item{sd.plot}{Boolean value (TRUE or FALSE) indicating if the standard deviation of each zeta diversity value must be plotted.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by \eqn{\zeta_1}, to get a range of values between 0 and 1.}

\item{empty.row}{Determines how to handle empty rows, i.e. sites with no species. Such sites can cause underestimations of zeta diversity. Options are  "\code{empty}" to let the data untreated or "\code{remove}" to remove the empty rows.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}
}
\value{
\code{Zeta.decline.ex} returns a list containing the following components:

\item{zeta.order}{The number of assemblages or sites for which the zeta diversity was computed.}

\item{combinations}{The number of possible combinations of sites for the chosen orders.}

\item{zeta.val}{The zeta diversity values.}

\item{zeta.val.sd}{The zeta diversity standard deviation values.}

\item{zeta.ratio}{The ratio of zeta diversity values by the zeta diversity values at the lower order \eqn{\zeta_i / \zeta_{i-1}}.}

\item{zeta.exp}{Object of class "\code{lm}", containing the output of the exponential regression.}

\item{zeta.exp.confint}{The confidence intervals of the coefficients of the exponential regression.}

\item{zeta.pl}{Object of class "\code{lm}", containing the output of the power law regression.}

\item{zeta.pl.confint}{The confidence intervals of the coefficients of the power law regression.}

\item{aic}{AIC values for \code{zeta.exp} and \code{zeta.pl}.}
}
\description{
Computes the expectation of zeta diversity, the number of species shared by multiple assemblages for a range of orders (number of assemblages or sites), using a formula based on the occupancy of the species, and fits the decline to an exponential and a power law relationship.
}
\details{
\code{Zeta.decline.ex} is much faster than \code{\link{Zeta.decline.mc}} to compute the exact value of zeta diversity when the number of species is lower than \eqn{C^N_{i}}, where \emph{N} is the total number of sites and \emph{i} is the order of zeta.

\code{sd.correct} should be set to \code{TRUE} if the assemblages represent a subsample of the whole system. It can be set to \code{FALSE} if the sampling is exhaustive, for example in case of a continuous regular grid covering the whole study area.

The exponential and the power law fit are performed using linear regressions on log-transformed data (only the zeta values are log-transformed for the exponential fit, and both the orders and the zeta values are log-transformed for the power law fit).
}
\examples{
utils::data(bird.spec.coarse)
data.spec.bird <- bird.spec.coarse[,3:193]

dev.new(width = 12, height = 4)
zeta.bird <- Zeta.decline.ex(data.spec.bird, orders = 1:5)
zeta.bird

##########

utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

dev.new(width = 12, height = 4)
zeta.marion <- Zeta.decline.ex(data.spec.marion, orders = 1:5)
zeta.marion

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

McGeoch M. A., Latombe G., Andrew N. R., Nakagawa S., Nipperess D. A., Roige M., Marzinelli E. M., Campbell A. H., Verges A., Thomas T., Steinberg P. D., Selwood K. E., Henriksen M. V. & Hui C. (2019). Measuring continuous compositional change using decline and decay in zeta diversity. \emph{Ecology}, 100(11), e02832.
}
\seealso{
\code{\link{Zeta.decline.mc}}, \code{\link{Zeta.order.mc}}, \code{\link{Zeta.order.ex}}, \code{\link{Plot.zeta.decline}}
}
